% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fork-and-merge.R
\name{mergeFork}
\alias{mergeFork}
\title{Merge changes to a dataset from a fork}
\usage{
mergeFork(dataset, fork, autorollback = TRUE, force = FALSE)
}
\arguments{
\item{dataset}{The \code{CrunchDataset} to merge to}

\item{fork}{The \code{CrunchDataset}, perhaps forked from \code{dataset},
that is to be merged in.}

\item{autorollback}{logical If the merge fails, should \code{dataset} be
restored to its state prior to the merge, or should it be left in its
partially merged state for debugging and manual fixing? Default is
\code{TRUE}, i.e. the former.}

\item{force}{logical Attempt to push through merge conflicts by dropping
all changes to \code{dataset} since \code{fork} diverged from and take only
the changes from \code{fork}? Default is \code{FALSE}, and it is recommended
only to use force=TRUE after first attempting and failing to merge without
forcing.}
}
\value{
\code{dataset} with changes from \code{fork} merged to it.
}
\description{
Merge changes to a dataset from a fork
}

