% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable-derivation.R
\docType{methods}
\name{derivations}
\alias{derivations}
\alias{derivation}
\alias{derivation<-}
\alias{derivation,CrunchVariable-method}
\alias{derivation<-,CrunchVariable,ANY-method}
\alias{derivation<-,CrunchVariable,NULL-method}
\alias{is.derived,CrunchVariable-method}
\alias{is.derived}
\alias{is.derived<-,CrunchVariable,logical-method}
\alias{is.derived<-}
\title{Get or set a derived variable's expression}
\usage{
\S4method{derivation}{CrunchVariable}(x)

\S4method{derivation}{CrunchVariable,ANY}(x) <- value

\S4method{derivation}{CrunchVariable,`NULL`}(x) <- value

\S4method{is.derived}{CrunchVariable}(x)

\S4method{is.derived}{CrunchVariable,logical}(x) <- value
}
\arguments{
\item{x}{a variable}

\item{value}{a \code{CrunchExpr} to be used as the derivation (for the setter
only) or \code{NULL} to integrate a derived variable. For \code{is.derived}, \code{FALSE}
can be used to integrate a derived variable.}
}
\value{
a \code{CrunchExpr} of the derivation for \code{derivation}; a logical for
\code{is.derived}; the variable given in \code{x} for \code{is.derived<-} returns
}
\description{
Get a derived variable's derivation formula as a (\code{CrunchExpr})\link{expressions} with
\code{derivation([variable])}. Set (change) a derived variable's derivation with
\code{derivation([variable]) <- [expression]}.
}
\details{
To integrate (aka realize or instantiate) a variable so that it is no longer
linked to the source variables that made up the derivation, use
\code{derivation([variable]) <- NULL}

\code{is.derived} can be used to see if a variable is derived or not. Additionally
setting a derived variable's \code{is.derived} to \code{FALSE} will integrate the
derived variable.
}
\examples{
\dontrun{

ds$derived_v1 <- ds$v1 + 5

derivation(ds$derived_v1)
# Crunch expression: v1 + 5

derivation(ds$derived_v1) <- ds$v1 + 10
derivation(ds$derived_v1)
# Crunch expression: v1 + 10

is.derived(ds$derived_v1)
# TRUE

# to integrate or instantiate the variable in place (remove the link between
# variable v1 and the derivation) you can:
derivation(ds$derived_v1) <- NULL

# after integrating, the derived variable is no longer derived.
is.derived(ds$derived_v1)
# FALSE
}
}
