% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{login}
\alias{login}
\title{Authenticate with the Crunch API}
\usage{
login(email = NULL, password = NULL, ...)
}
\arguments{
\item{email}{the email address associated with the user's Crunch account}

\item{password}{the password associated with the user's Crunch account}

\item{...}{additional parameters passed in the authentication. Not
currently supported by the Crunch API.}
}
\description{
Note that you can store your Crunch account info in encrypted format via
the keyring package, with \code{key_set(service = "crunch", "<USERNAME>", ...)}
If you do so, you can simply \code{login()} to authenticate. For running batch jobs,
this could be particularly useful.
}
\details{
Your email and password can also be stored in and read from the
environmental variables \code{R_CRUNCH_EMAIL} and \code{R_CRUNCH_PW},
or from your .Rprofile under \code{crunch.email} and \code{crunch.pw}.
However, environmental variables and \code{.RProfile} files are not encrypted, so
this practice is no longer recommended. If an email or password is found in
multiple locations, priority is given to 1) environmental variables, 2)
\code{.RProfile}, and 3) keyring. This order of priority is for backwards compatibility,
and methods 1) and 2) are no longer recommended.

If a password is not stored in any of these locations, and you are in an
interactive session, you will be prompted to enter your password.
}
