% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hide-variables.R
\name{hideVariables}
\alias{hiddenVariables<-}
\alias{hideVariables}
\alias{unhideVariables}
\title{Hide and Unhide Variables Within a Dataset}
\usage{
hideVariables(dataset, variables = NULL, pattern = NULL,
  key = namekey(dataset), ...)

hiddenVariables(x) <- value

unhideVariables(dataset, variables = NULL, pattern = NULL,
  key = namekey(dataset), ...)
}
\arguments{
\item{dataset}{the Dataset to modify}

\item{variables}{names or indices of variables to (un)hide}

\item{pattern}{optional regular expression to identify Variables to (un)hide}

\item{key}{the Variable attribute to \code{\link{grep}} with the
\code{pattern}. Default is "alias"}

\item{...}{optional additional arguments to \code{grep}}

\item{x}{same as \code{dataset}, for `hiddenVariables<-`}

\item{value}{same as \code{variables}, for `hiddenVariables<-`}
}
\value{
(invisibly) \code{dataset} with the specified variables (un)hidden
}
\description{
Hide and Unhide Variables Within a Dataset
}
\seealso{
\code{\link{hide}}
}

