## ---- results='hide', echo=FALSE, message=FALSE-----------------------------------------------------------------------
library(crunch)
load("analyze.RData")
options(width=120)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  tab1 <- crtabs(~ educ, data=ds)
#  tab1

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab1

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  tab2 <- crtabs(~ educ + gender, data=ds)
#  tab2

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab2

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  weight(ds)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
print(NULL)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  weight(ds) <- ds$weight

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  crtabs(~ educ + gender, data=ds)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab2weighted

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  crtabs(~ educ + gender, data=ds, weight=NULL)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab2

## ---------------------------------------------------------------------------------------------------------------------
prop.table(tab1)

## ---------------------------------------------------------------------------------------------------------------------
prop.table(tab2, 2)

## ---------------------------------------------------------------------------------------------------------------------
round(100*prop.table(tab2, 2))

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  tab3 <- crtabs(~ imiss + gender, data=ds)
#  tab3

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab3

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  ds$imiss <- dichotomize(ds$imiss, c("Very Important", "Somewhat Important"))

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  tab3mr <- crtabs(~ imiss + gender, data=ds)
#  tab3mr

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab3mr

## ---------------------------------------------------------------------------------------------------------------------
class(tab3mr)

## ---------------------------------------------------------------------------------------------------------------------
round(100*prop.table(tab3mr, 2))

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  crtabs(~ imiss$Education + gender, data=ds)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab3subvar

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  round(crtabs(~ imiss + educ + gender, data=ds))

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
round(tab4)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  crtabs(mean(age) ~ educ + gender, data=ds)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab5

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  crtabs(min(age) ~ educ + gender, data=ds)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab6

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  crtabs(min(age) ~ 1, data=ds)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
tab6a

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  categories(ds$track)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
print(track.cats)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  round(crtabs(mean(track) ~ educ + gender, data=ds), 2)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
round(tab7, 2)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  round(crtabs(mean(track) ~ educ + gender, data=ds[ds$pid3 == "Democrat",]), 2)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
round(tab8, 2)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  ds$snowdenleakapp

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
cat(snowdenleakapp.var, sep="\n")

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  ols1 <- lm(I(snowdenleakapp == "Strongly approve") ~ newsint2 + pid3 + gender + age,
#      data=ds)
#  summary(ols1)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
summary(ols1)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  logit1 <- glm(I(snowdenleakapp == "Strongly approve") ~ newsint2 + pid3 + gender + age,
#      family=binomial(link="logit"), data=ds)
#  summary(logit1)

## ---- echo=FALSE------------------------------------------------------------------------------------------------------
summary(logit1)

