% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-export.R
\name{cruts2raster}
\alias{cruts2raster}
\title{cruts2raster function}
\usage{
cruts2raster(ncfile, timeRange = NULL, poly = NULL, offset = "1900-01-01",
  type = "stack")
}
\arguments{
\item{ncfile}{character string giving name and location of the CRUTS time series NetCDF file (if the file you downloaded is zipped, then you will need to extract it)}

\item{timeRange}{vector of length 2 giving the start and end dates in the first and second place. Dates are converted using the function ymd, please refer to the help for this funciton for details on appropriate formats.}

\item{poly}{an optional SpatialPolygonsDataFrame on which to crop the raster to}

\item{offset}{time offset for CRU TS data}

\item{type}{can be either 'brick' or 'stack' (thde default), this argument specifies what sort of raster object to return.}
}
\value{
a raster stack or brick containing the raw data
}
\description{
A function to convert Climatic Research Unit Time-Series in NetCDF format to raster format.
}
\details{
Data can be obtained from \url{http://catalogue.ceda.ac.uk/uuid/ac4ecbd554d0dd52a9b575d9666dc42d}
}
\examples{
\dontrun{crutsimport(ncfile="my_cruts_file.nc",timeRange=c("2000-01-01","2001-01-01"))}
}

