% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getQuote.R
\name{getQuote}
\alias{getQuote}
\title{Get a quote on a cryptopair from one
of the major exchanges}
\usage{
getQuote(
  ticker,
  source = "binance",
  futures = TRUE,
  interval,
  from = NULL,
  to = NULL
)
}
\arguments{
\item{ticker}{A character vector of length 1. Uppercase.}

\item{source}{A character vector of length 1. See \code{\link[=availableExchanges]{availableExchanges()}} for a full list of available exchanges.}

\item{futures}{A logical value. TRUE by default. If FALSE, the function will return spot prices.}

\item{interval}{A character vector of length 1. See \code{\link[=availableIntervals]{availableIntervals()}} for a full list.}

\item{from}{A character vector of length 1. Given in \%Y-\%m-\%d format.}

\item{to}{A character vector of length 1. Given in \%Y-\%m-\%d format.}
}
\value{
an xts object with Open, High, Low, Close and Volume.
}
\description{
This function returns a crypto quote from
one of the available exchanges. The function supports
futues and spot markets
}
\examples{
# 1) load perpetual
# futures from Binance
# with 15m intervals
perpAtom <- try(
  cryptoQuotes::getQuote(
    ticker  = 'ATOMUSDT',
    source = 'binance',
    interval = '15m',
    futures = TRUE
  )
)

# 2) chart the futures
# using the chart
# function
if (!inherits(perpAtom, 'try-error')){
  cryptoQuotes::chart(
    chart = cryptoQuotes::kline(perpAtom) \%>\%
      cryptoQuotes::addVolume()   \%>\%
        cryptoQuotes::addBBands(cols = c('Close'))
  )
}

# NOTE: Without the try
# the examples fails on
# Github Actions


# script end;
}
