% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_report.R
\name{print_report}
\alias{print_report}
\title{Print full crypto tax report}
\usage{
print_report(tax.year, name, report.info)
}
\arguments{
\item{tax.year}{The tax year desired.}

\item{name}{Name of the individual for the report.}

\item{report.info}{The report info obtained from \code{prepare_report()}.}
}
\value{
An HTML page containing a crypto tax report.
}
\description{
Will output a full crypto tax report in HTML format, which can then be printed or saved as PDF.
}
\examples{
\donttest{
list.prices <- prepare_list_prices(coins = "BTC", start.date = "2021-01-01")
all.data <- format_shakepay(data_shakepay)
formatted.ACB <- format_ACB(all.data, verbose = FALSE)
report.info <- prepare_report(formatted.ACB, 2021, list.prices = list.prices)
print_report(2021, "Mr. Cryptoltruist", report.info)
}
\dontshow{
unlink("full_report.html")
}

}
