% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csa.R
\name{csa}
\alias{csa}
\title{Estimate and print the temporal CSA plot}
\usage{
csa(
  x,
  stat = "var",
  std = TRUE,
  threshold = 30,
  plot = TRUE,
  fast = FALSE,
  chk = FALSE,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{stat}{The statistic which will be estimated across the cross-scale continuum. Suitable options are:
\itemize{
\item{"var" for variance,}
\item{"sd" for standard deviation,}
\item{"skew" for skewness,}
\item{"kurt" for kurtosis,}
\item{"l2" for L-scale,}
\item{"t2" for coefficient of L-variation,}
\item{"t3" for L-skewness,}
\item{"t4" for L-kurtosis.}
}}

\item{std}{logical. If TRUE (the default) the CSA plot is standardized to unit, i.e., zero mean and unit variance in the original time scale.}

\item{threshold}{numeric. Sample size of the time series at the last aggregated scale.}

\item{plot}{logical. If TRUE (the default) the CSA plot is printed.}

\item{fast}{logical. If TRUE the CSA plot is estimated only in logarithmic scale; 1, 2, 3, ... , 10, 20, 30, ... , 100, 200, 300 etc.}

\item{chk}{logical. If TRUE the number of cores is limited to 2.}

\item{...}{log_x and log_y (default TRUE) for setting the axes of the CSA plot to logarithmic scale. The argument wn (default FALSE) is used to plot a line presenting the standardized variance of the white noise process. Therefore, it should be used only with stat = "var" and std = T.}
}
\value{
If \code{plot = TRUE}, the \code{csa} returns a list containing:
 \itemize{
 \item{\code{values}: Matrix of the timeseries values for the selected \code{stat} at each \code{scale}.}
 \item{\code{plot}: Plot of \code{scale} versus \code{stat} as a \emph{ggplot} object.}
 }
 If \code{plot = FALSE}, then it returns only the matrix of the timeseries values for the selected \code{stat} at each \code{scale}.
}
\description{
The function \code{csa} computes (and by default plots) the aggregation curve of a given statistic in a single dimension, e.g., time.
}
\examples{
\donttest{
csa(rnorm(1000), wn = TRUE)
data(gpm_nl, knmi_nl, rdr_nl, ncep_nl, cnrm_nl, gpm_events)
csa(knmi_nl$prcp, threshold = 10, fast = TRUE)

csa(gpm_nl$prcp, stat = "skew", std = FALSE, log_x = FALSE, log_y = FALSE, smooth = TRUE)

gpm_skew <- csa(gpm_nl$prcp, stat = "skew", std = FALSE, log_x = FALSE, log_y = FALSE,
smooth = TRUE, plot = FALSE)
rdr_skew <- csa(rdr_nl$prcp, stat = "skew", std = FALSE, log_x = FALSE, log_y = FALSE,
smooth = TRUE, plot = FALSE)
csa.multiplot(rbind(data.frame(gpm_skew, dataset = "gpm"), data.frame(rdr_skew,
dataset = "rdr")), log_x = FALSE, log_y = FALSE, smooth = TRUE)

set_1 <- data.frame(csa(gpm_nl$prcp, plot = FALSE, fast = TRUE), dataset = "gpm")
set_2 <- data.frame(csa(rdr_nl$prcp, plot = FALSE, fast = TRUE), dataset = "radar")
set_3 <- data.frame(csa(knmi_nl$prcp, plot = FALSE, fast = TRUE), dataset = "station")
set_4 <- data.frame(csa(ncep_nl$prcp, plot = FALSE, fast = TRUE), dataset = "ncep")
set_5 <- data.frame(csa(cnrm_nl$prcp, plot = FALSE, fast = TRUE), dataset = "cnrm")
csa.multiplot(rbind(set_1, set_2, set_3, set_4, set_5))
}
}
\references{
Markonis et al., A cross-scale analysis framework for model/data comparison and integration, Geoscientific Model Development, Submitted.
}
