% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_black_list.R
\name{create_black_list}
\alias{create_black_list}
\title{Creates a black list of genomic loci based on a background panel created from a list of bam files (e.g. healthy samples)}
\usage{
create_black_list(background_panel, mean_vaf_quantile = 0.95,
  min_samples_one_read = max(2, ceiling(ncol(background_panel$vaf) *
  0.75)), min_samples_two_reads = max(2,
  ceiling(ncol(background_panel$vaf) * 0.2)), min_samples_n_reads = NA,
  n_reads = NA)
}
\arguments{
\item{background_panel}{A list produced by create_background panel function}

\item{mean_vaf_quantile}{The quantile of mean VAF above which the loci are considered noisy. Use NA to skip this criterion.}

\item{min_samples_one_read}{Loci that at least this number of samples exhibit at least one non-reference reads are considered noisy. Use NA to skip this criterion.}

\item{min_samples_two_reads}{Loci that at least this number of samples exhibit at least two non-reference reads are considered noisy. Use NA to skip this criterion.}

\item{min_samples_n_reads}{Loci that at least this number of samples exhibit at least n non-reference reads (\code{n_reads} parameter) are considered noisy. Use NA to skip this criterion.}

\item{n_reads}{the number of reads to use in the \code{min_samples_n_reads} parameter}
}
\value{
a character vector of the loci in the black list
}
\description{
The function applies criteria on the background panel to extract the noisy genomic loci. Criteria include minimum number of samples having
at least one, at least two, or at least n (\code{n_reads} parameter) non-reference allele. Additionally the quantile of mean VAF above which the loci are considered noisy
}
\examples{
\donttest{
## Load example data
data("targets", package = "ctDNAtools")
bamN1 <- system.file("extdata", "N1.bam", package = "ctDNAtools")
bamN2 <- system.file("extdata", "N2.bam", package = "ctDNAtools")
bamN3 <- system.file("extdata", "N3.bam", package = "ctDNAtools")

## Use human reference genome from BSgenome.Hsapiens.UCSC.hg19 library
suppressMessages(library(BSgenome.Hsapiens.UCSC.hg19))

## Use a black list based on loci
bg_panel <- create_background_panel(
  bam_list = c(bamN1, bamN2, bamN3),
  targets = targets, reference = BSgenome.Hsapiens.UCSC.hg19,
  substitution_specific = FALSE
)

bl1 <- create_black_list(bg_panel,
  mean_vaf_quantile = 0.99,
  min_samples_one_read = 2, min_samples_two_reads = 1,
  min_samples_n_reads = 1, n_reads = 3
)

## Use a substitution-specific black list
bg_panel <- create_background_panel(
  bam_list = c(bamN1, bamN2, bamN3),
  targets = targets, reference = BSgenome.Hsapiens.UCSC.hg19,
  substitution_specific = TRUE
)

bl2 <- create_black_list(bg_panel,
  mean_vaf_quantile = 0.99,
  min_samples_one_read = 2, min_samples_two_reads = 1,
  min_samples_n_read = NA
)
}

}
\seealso{
\code{\link{create_background_panel}}  \code{\link{test_ctDNA}}
}
