% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ctrGetQueryUrlFromBrowser}
\alias{ctrGetQueryUrlFromBrowser}
\title{Import from clipboard the URL of a search in one of the registers}
\usage{
ctrGetQueryUrlFromBrowser(url = "", register = "")
}
\arguments{
\item{url}{URL such as from the browser address bar.
If not specified, clipboard contents will be checked for
a suitable URL. Can also contain a query term such as from
\link{dbQueryHistory}()["query-term"]}

\item{register}{Optional name of register (i.e., "EUCTR" or
"CTGOV") in case url is a query term}
}
\value{
A string of query parameters that can be used to retrieve data
from the register.

A data frame with column names query term and register name
that can directly be used in \link{ctrLoadQueryIntoDb} and in
\link{ctrOpenSearchPagesInBrowser}
}
\description{
Import from clipboard the URL of a search in one of the registers
}
\examples{

\dontrun{
db <- nodbi::src_sqlite(
  collection = "my_collection"
)

# user now copies into the clipboard the URL from
# the address bar of the browser that shows results
# from a query in one of the trial registers
ctrLoadQueryIntoDb(
  ctrGetQueryUrlFromBrowser(),
  con = db
)
}

}
