% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDiscretePars.R
\name{ctStanDiscretePars}
\alias{ctStanDiscretePars}
\title{ctStanDiscretePars}
\usage{
ctStanDiscretePars(
  ctstanfitobj,
  subjects = "popmean",
  times = seq(from = 0, to = 10, by = 0.1),
  nsamples = 100,
  observational = FALSE,
  standardise = FALSE,
  cov = FALSE,
  plot = FALSE,
  cores = 2,
  ...
)
}
\arguments{
\item{ctstanfitobj}{Continuous time model fit from \code{\link{ctStanFit}}}

\item{subjects}{Either 'popmean', to use the population mean parameter, or a vector of integers denoting which
subjects.}

\item{times}{Numeric vector of positive values, discrete time parameters will be calculated for each.}

\item{nsamples}{Number of samples from the stanfit to use for plotting. Higher values will
increase smoothness / accuracy, at cost of plotting speed. Values greater than the total
number of samples will be set to total samples.}

\item{observational}{Logical. If TRUE, outputs expected change in processes *conditional on observing* a 1 unit change in each -- 
this change is correlated according to the DIFFUSION matrix. If FALSE, outputs expected regression values -- also interpretable as
an independent 1 unit change on each process, giving the expected response under a 1 unit experimental impulse.}

\item{standardise}{Logical. If TRUE, output is standardised according to expected total within subject variance, given by the 
asymDIFFUSION matrix.}

\item{cov}{Logical. If TRUE, covariances are returned instead of regression coefficients.}

\item{plot}{Logical. If TRUE, plots output using \code{\link{ctStanDiscreteParsPlot}}
instead of returning output.}

\item{cores}{Number of cpu cores to use for computing subject matrices. 
If subject matrices were saved during fiting, not used.}

\item{...}{additional plotting arguments to control \code{\link{ctStanDiscreteParsPlot}}}
}
\description{
Calculate model implied regressions for a sequence of time intervals based on a continuous time model fit
from ctStanFit, for specified subjects.
}
\examples{
if(w32chk()){

ctStanDiscretePars(ctstantestfit,times=seq(.5,4,.1), 
 plot=TRUE,indices='CR')
 
#modify plot
require(ggplot2)
g=ctStanDiscretePars(ctstantestfit,times=seq(.5,4,.1), 
 plot=TRUE,indices='CR')
g= g+ labs(title='Cross effects')
print(g)

}
}
