% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanoptimis.R
\name{stanoptimis}
\alias{stanoptimis}
\title{Optimize / importance sample a stan or ctStan model.}
\usage{
stanoptimis(
  standata,
  sm,
  init = "random",
  initsd = 0.01,
  sampleinit = NA,
  deoptim = FALSE,
  estonly = FALSE,
  tol = 1e-10,
  decontrol = list(),
  stochastic = TRUE,
  nopriors = FALSE,
  carefulfit = TRUE,
  subsamplesize = 1,
  finitediff = FALSE,
  parsteps = c(),
  plot = FALSE,
  is = FALSE,
  isloopsize = 1000,
  finishsamples = 1000,
  tdf = 10,
  chancethreshold = 100,
  finishmultiply = 5,
  verbose = 0,
  cores = 2,
  matsetup = NA,
  nsubsets = 10,
  stochasticTolAdjust = 1
)
}
\arguments{
\item{standata}{list object conforming to rstan data standards.}

\item{sm}{compiled stan model object.}

\item{init}{vector of unconstrained parameter values, or character string 'random' to initialise with
random values very close to zero.}

\item{initsd}{positive numeric specifying sd of normal distribution governing random sample of init parameters,
if init='random' .}

\item{sampleinit}{either NA, or an niterations * nparams matrix of samples to initialise importance sampling.}

\item{deoptim}{Do first pass optimization using differential evolution? Slower, but better for cases with multiple
minima / difficult optimization.}

\item{estonly}{if TRUE,just return point estimates under $rawest subobject.}

\item{tol}{objective tolerance.}

\item{decontrol}{List of control parameters for differential evolution step, to pass to \code{DEoptim.control}.}

\item{stochastic}{Logical. Use stochastic gradient descent instead of mize (bfgs) optimizer.
Still experimental, worth trying for either robustness checks or problematic, high dimensional, nonlinear, problems.}

\item{nopriors}{logical. If TRUE, a nopriors integer is set to 1 (TRUE) in the standata object -- only has an effect if 
the stan model uses this value.}

\item{carefulfit}{Logical. If TRUE, priors are always used for a rough first pass to obtain starting values when nopriors=TRUE.}

\item{subsamplesize}{value between 0 and 1 representing proportion of subjects to include in first pass fit.}

\item{finitediff}{Either 'ask', TRUE, or FALSE. Whether to use the slow finite difference calculations
for the Hessian (used for confidence intervals) if other approaches do not give a positive definite result.}

\item{parsteps}{ordered list of vectors of integers denoting which parameters should begin fixed
at zero, and freed sequentially (by list order). Useful for complex models, e.g. keep all cross couplings fixed to zero 
as a first step, free them in second step.}

\item{plot}{Logical. If TRUE, plot iteration details. Probably slower.}

\item{is}{Logical. Use importance sampling, or just return map estimates?}

\item{isloopsize}{Number of samples of approximating distribution per iteration of importance sampling.}

\item{finishsamples}{Number of samples to draw (either from hessian
based covariance or posterior distribution) for final results computation.}

\item{tdf}{degrees of freedom of multivariate t distribution. Higher (more normal) generally gives more efficent
importance sampling, at risk of truncating tails.}

\item{chancethreshold}{drop iterations of importance sampling where any samples are chancethreshold times more likely to be drawn than expected.}

\item{finishmultiply}{Importance sampling stops once available samples reach \code{finishsamples * finishmultiply} , then the final samples are drawn
without replacement from this set.}

\item{verbose}{Integer from 0 to 2. Higher values print more information during model fit -- for debugging.}

\item{cores}{Number of cpu cores to use, should be at least 2.}

\item{matsetup}{subobject of ctStanFit output. If provided, parameter names instead of numbers are output for any problem indications.}

\item{nsubsets}{number of subsets for stochastic optimizer. Subsets are further split across cores, 
but each subjects data remains whole -- processed by one core in one subset.}

\item{stochasticTolAdjust}{Multiplier for initial subsampling optimizer tolerance.}
}
\value{
list containing fit elementsF
}
\description{
Optimize / importance sample a stan or ctStan model.
}
