% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_evolution_graph.R
\encoding{UTF-8}
\name{rate_evolution_graph}
\alias{rate_evolution_graph}
\title{Constructs the rate evolution graph for a categorical time series}
\usage{
rate_evolution_graph(series, categories, title = "Rate evolution graph", ...)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{title}{The title of the graph.}

\item{...}{Additional parameters for the function.}
}
\value{
The rate evolution graph.
}
\description{
\code{rate_evolution_graph} constructs the rate evolution graph
proposed by \insertCite{ribler1997visualizing;textual}{ctsfeatures}.
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, and the
corresponding binarized time series, \eqn{\overline{\boldsymbol Y}_t=\{\overline{\boldsymbol Y}_1, \ldots, \overline{\boldsymbol Y}_T\}},
the function constructs the rate evolution graph. Specifically, consider the
series of cumulated sums given by \eqn{\overline{\boldsymbol C}_t=\{\overline{\boldsymbol C}_1, \ldots, \overline{\boldsymbol C}_T\}}, with
\eqn{\overline{\boldsymbol C}_k=\sum_{s=1}^{k}\overline{\boldsymbol Y}_s},
\eqn{k=1,\ldots,T}. The rate evolution graph displays a standard time series
plot for each one of the components of \eqn{\overline{\boldsymbol C}_t}
simultaneously in one graph.
}
\examples{
reg <- rate_evolution_graph(GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Constructing the rate
# evolution graph for the first time series in dataset GeneticSequences
}
\references{
{

  \insertRef{ribler1997visualizing}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
