% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{check_existence_by_dtxsid}
\alias{check_existence_by_dtxsid}
\title{Check existence by DTXSID}
\usage{
check_existence_by_dtxsid(
  DTXSID = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating whether some "progress report" should be
given.}
}
\value{
A data.table with information on whether the input DTXSID is valid,
and where to find more information on the chemical when the DTXSID is valid.
}
\description{
Check existence by DTXSID
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# DTXSID for bpa
bpa <- check_existence_by_dtxsid('DTXSID7020182')
# False DTXSID
false_res <- check_existence_by_Dtxsid('DTXSID7020182f')
\dontshow{\}) # examplesIf}
}
