% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.LL.quantile.R
\name{calc.LL.quantile}
\alias{calc.LL.quantile}
\title{Compute the time to statistical cure using the loss of lifetime function}
\usage{
calc.LL.quantile(
  fit,
  q = 1,
  newdata = NULL,
  max.time = 20,
  var.type = c("ci", "n"),
  exp.fun = NULL,
  rmap = NULL,
  ratetable = cuRe::survexp.dk,
  tau = 100,
  type = "ll",
  scale = ayear
)
}
\arguments{
\item{fit}{Fitted model to do predictions from. Possible classes are
\code{gfcm}, \code{cm}, \code{stpm2}, and \code{pstpm2}.}

\item{q}{Threshold to estimate statistical cure according to.}

\item{newdata}{Data frame from which to compute predictions. If empty, predictions are made on the the data which
the model was fitted on.}

\item{max.time}{Upper boundary of the interval [0, \code{max.time}] in which to search for solution (see details).
Default is 20.}

\item{var.type}{Character. Possible values are "\code{ci}" (default) for confidence intervals,
"\code{se}" for standard errors, and "\code{n}" for neither.}

\item{exp.fun}{Object of class \code{list} containing functions for the expected survival
of each row in \code{newdata}. If not specified, the function computes the expected
survival based on \code{newdata} using the \code{survival::survexp} function. If \code{newdata} is not provided,
the expected survival is based on the data which the model was fitted on.}

\item{rmap}{List to be passed to \code{survexp} from the \code{survival} package if \code{exp.fun = NULL}.
Detailed documentation on this argument can be found by \code{?survexp}.}

\item{ratetable}{Object of class \code{ratetable} used to compute the general population survival.
Default is \code{survexp.dk}}

\item{tau}{Upper bound of integral (see ?calc.LL). Default is 100.}

\item{type}{Type of life expectancy measure. Possible values are \code{type = "ll"} for the loss of lifetime
and \code{type = "mrl"} for the mean residual lifetime.}

\item{scale}{Numeric. Passed to the \code{survival::survexp} function and defaults to 365.24.
That is, the time scale is assumed to be in years.}
}
\value{
The estimated cure point.
}
\description{
The following function estimates the time to statistical cure using the
loss of lifetime function.
}
\examples{
##Use data cleaned version of the colon cancer data from the rstpm2 package
data("colonDC")
set.seed(2)
colonDC <- colonDC[sample(1:nrow(colonDC), 1000), ]

##Extract general population hazards
colonDC$bhaz <- general.haz(time = "FU", rmap = list(age = "agedays", sex = "sex", year= "dx"),
                            data = colonDC, ratetable = survexp.dk)

#Fit cure model and estimate cure point
fit <- rstpm2::stpm2(Surv(FUyear, status) ~ 1, data = colonDC, df = 6,
                     bhazard = colonDC$bhaz, cure = TRUE)
calc.LL.quantile(fit, q = 1,
                 rmap = list(age = agedays, sex = sex, year = dx))
}
