% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lts.R
\name{lts}
\alias{lts}
\title{Long term survival predictions}
\usage{
lts(
  fit,
  type = c("surv", "hazard", "cumhaz", "loghaz", "fail"),
  newdata = NULL,
  time = NULL,
  var.type = c("ci", "se", "n"),
  exp.fun = NULL,
  ratetable = cuRe::survexp.dk,
  rmap,
  scale = 365.24,
  smooth.exp = FALSE,
  link = NULL,
  mean = FALSE
)
}
\arguments{
\item{fit}{Fitted model to do predictions from. Possible classes are \code{gfcm}, \code{stpm2},
\code{pstpm2}, and \code{cm}.}

\item{type}{Prediction type (see details). The default is \code{surv}.}

\item{newdata}{Data frame from which to compute predictions. If empty, predictions are made on the the data which
the model was fitted on.}

\item{time}{Optional time points at which to compute predictions. If empty, a grid of 100 time points between 0
and the maximum follow-up time is selected.}

\item{var.type}{Character. Possible values are "\code{ci}" (default) for confidence intervals,
"\code{se}" for standard errors, and "\code{n}" for neither.}

\item{exp.fun}{Object of class \code{list} containing functions for the expected survival
of each row in \code{newdata}. If not specified, the function computes the expected
survival based on \code{newdata} using the \code{survival::survexp} function. If \code{newdata} is not provided,
the expected survival is based on the data which the model was fitted on.}

\item{ratetable}{Object of class \code{ratetable} used to compute the general population survival.
Default is \code{survexp.dk}.}

\item{rmap}{List to be passed to \code{survexp} from the \code{survival} package if \code{exp.fun = NULL}.
Detailed documentation on this argument can be found by \code{?survexp}.}

\item{scale}{Numeric. Passed to the \code{survival::survexp} function and defaults to 365.24.
That is, the time scale is assumed to be in years.}

\item{smooth.exp}{Logical. If \code{TRUE}, the general population survival function is smoothed by the function
\code{smooth.spline} using the the argument \code{all.knots = TRUE}.}

\item{link}{Character, indicating the link function for the variance calculations.
Possible values are "\code{log}", "\code{cloglog}" for \eqn{log(-log(x))} , "\code{mlog}" for -log(x),
and "\code{I}" for the indentity.}

\item{mean}{Logical. If \code{TRUE}, the function outputs the average estimate across the
rows in \code{newdata}. If \code{newdata = NULL}, the argument is not used. The default is \code{FALSE}.}
}
\value{
An object of class \code{lts} containing the predictions of each individual in \code{newdata}.
}
\description{
Function for computing survival estimates using a relative survival model and the
expected general population survival.
}
\details{
Possible values for argument \code{type} are:\cr
\code{surv}: Survival function computed by \eqn{S(t) = R(t)S^*(t)}\cr
\code{hazard}: Hazard function computed by \eqn{h(t) = \lambda(t) + h^*(t)}\cr
\code{cumhaz}: The cumulative hazard function computed by \eqn{H(t) = \Lambda(t) + H^*(t)}\cr
\code{loghazard}: The log-hazard function computed by \eqn{\log(\lambda(t) + h^*(t))}\cr
\code{fail}: The distribution function computed by \eqn{1 - R(t)S^*(t)}
}
\examples{
##Use data cleaned version of the colon cancer data from the rstpm2 package
data("colonDC")
set.seed(2)
colonDC <- colonDC[sample(1:nrow(colonDC), 1000), ]

##Extract general population hazards
colonDC$bhaz <- general.haz(time = "FU", rmap = list(age = "agedays", sex = "sex", year= "dx"),
                            data = colonDC, ratetable = survexp.dk)

##Fit flexible parametric relative survival model
fit <- stpm2(Surv(FUyear, status) ~ 1, data = colonDC, df = 6, bhazard = colonDC$bhaz)

##Compute survival probabilities from 0 to 20 years
pred <- lts(fit, rmap = list(age = agedays, sex = sex, year = dx))

##Plot the survival function
plot(pred)
}
