% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_weight.R
\name{est_trna_weight}
\alias{est_trna_weight}
\title{Estimate tRNA weight w}
\usage{
est_trna_weight(
  trna_level,
  codon_table = get_codon_table(),
  s = list(WC = 0, IU = 0, IC = 0.4659, IA = 0.9075, GU = 0.7861, UG = 0.6295)
)
}
\arguments{
\item{trna_level, }{named vector of tRNA level (or gene copy numbers), one value for each anticodon.
vector names are anticodons.}

\item{codon_table}{a table of genetic code derived from \code{get_codon_table} or \code{create_codon_table}.}

\item{s}{list of non-Waston-Crick pairing panelty.}
}
\value{
data.table of tRNA expression information.
}
\description{
\code{est_trna_weight} compute the tRNA weight per codon for TAI calculation.
This weight reflects relative tRNA availability for each codon.
}
\examples{
# estimate codon tRNA weight for yeasts
est_trna_weight(yeast_trna_gcn)

}
\references{
dos Reis M, Savva R, Wernisch L. 2004. Solving the riddle of codon usage preferences: a test for translational selection. Nucleic Acids Res 32:5036-5044.
}
