% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_cure_dataframe.R
\name{calculate_cure_dataframe}
\alias{calculate_cure_dataframe}
\title{Calculate CURE Dataframe}
\usage{
calculate_cure_dataframe(covariate_values, residuals)
}
\arguments{
\item{covariate_values}{name to be plot. With or without quotes.}

\item{residuals}{Residuals.}
}
\value{
A data frame with five columns: independent variable, residuals,
  cumulative residuals, lower confidence interval limit, and upper
  confidence interval limit.
}
\description{
Calculate CURE Dataframe
}
\examples{
set.seed(2000)

## Define parameters
beta <- c(-1, 0.3, 3)

## Simulate independent variables
n <- 900
AADT <- c(runif(n, min = 2000, max = 150000))
nlanes <- sample(x = c(2, 3, 4), size = n, replace = TRUE)
LNAADT <- log(AADT)

## Simulate dependent variable
theta <- exp(beta[1] + beta[2] * LNAADT + beta[3] * nlanes)
y <- rpois(n, theta)

## Fit model
mod <- glm(y ~ LNAADT + nlanes, family = poisson)

## Calculate residuals
res <- residuals(mod, type = "working")

## Calculate CURE plot data
cure_df <- calculate_cure_dataframe(AADT, res)

head(cure_df)
}
