% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_list}
\alias{cvd_indicator_list}
\title{List indicators}
\usage{
cvd_indicator_list(time_period_id = 1, system_level_id = 2)
}
\arguments{
\item{time_period_id}{integer - time period to reutrn data for (compulsory)}

\item{system_level_id}{integer - system level to return data for (compulsory)}
}
\value{
Tibble of details for indicators for the time period and system level
}
\description{
Returns basic details of all indicators for a given system level and time period.
Only returns indicators for which data exists in selected time period, and on
selected system level. Used to populate available indicator list in Data Explorer.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2Flist}{Indicator list}
}
\examples{
# List four indicators for time point 17 and GP practice level (system level 5)
cvd_indicator_list(time_period_id = 17, system_level_id = 5) |>
  dplyr::select(IndicatorID, IndicatorCode, IndicatorShortName) |>
  dplyr::slice_head(n = 4)
}
\seealso{
\code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}},
\code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}}, \code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}}, #
\code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
