% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cobra_pod.r
\name{cobra_pod}
\alias{cobra_pod}
\title{MM algorithm for Convex Biclustering with Missing Data}
\usage{
cobra_pod(X, Lambda_row, Lambda_col, E_row, E_col, w_row, w_col, Theta,
  max_iter = 100, tol = 0.001, max_iter_inner = 1000, tol_inner = 1e-04)
}
\arguments{
\item{X}{The data matrix to be clustered. The rows are the features, and the columns are the samples.}

\item{Lambda_row}{Initial guess of row Langrage multipliers}

\item{Lambda_col}{Initial guess of column Langrage multipliers}

\item{E_row}{Edge-incidence matrix for row graph}

\item{E_col}{Edge-incidence matrix for column graph}

\item{w_row}{Vector of weights for row graph}

\item{w_col}{Vector of weights for column graph}

\item{Theta}{A vector of missing indices - row major order}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Stopping criterion}

\item{max_iter_inner}{Maximum number of inner cobra iterations}

\item{tol_inner}{Stopping criterion for inner cobra loop}
}
\description{
\code{cobra_pod} performs convex biclustering on incomplete data matrices using an MM algorithm.
}
\examples{
## Create bicluster path
## Example: Lung
X <- lung
X <- X - mean(X)
X <- X/norm(X,'f')

## Create annotation for heatmap
types <- colnames(lung)
ty <- as.numeric(factor(types))
cols <- rainbow(4)
YlGnBu5 <- c('#ffffd9','#c7e9b4','#41b6c4','#225ea8','#081d58')
hmcols <- colorRampPalette(YlGnBu5)(256)

## Construct weights and edge-incidence matrices
phi <- 0.5; k <- 5
wts <- gkn_weights(X,phi=phi,k_row=k,k_col=k)
w_row <- wts$w_row
w_col <- wts$w_col
E_row <- wts$E_row
E_col <- wts$E_col

## Connected Components of Row and Column Graphs
wts$nRowComp
wts$nColComp

## Generate random initial dual variables
set.seed(12345)
n <- ncol(X); p <- nrow(X)
m_row <- nrow(E_row); m_col <- nrow(E_col)
Lambda_row <- matrix(rnorm(n*m_row),n,m_row)
Lambda_col <- matrix(rnorm(p*m_col),p,m_col)

#### Initialize path parameters and structures
gam <- 200

## Create random mask
nMissing <- floor(0.1*n*p)
Theta <- sample(1:(n*p), nMissing, replace=FALSE)

sol <- cobra_pod(X,Lambda_row,Lambda_col,E_row,E_col,gam*w_row,gam*w_col,Theta)

heatmap(sol$U,col=hmcols,labRow=NA,labCol=NA,ColSideCol=cols[ty])
}

