% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.classo.R
\name{print.classo}
\alias{print.classo}
\title{print a classo object}
\usage{
\method{print}{classo}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{fitted classo object}

\item{digits}{significant digits in printout}

\item{\dots}{additional print arguments}
}
\value{
The matrix above is silently returned
}
\description{
Print a summary of the classo path at each step along the path.
}
\details{
The call that produced the object \code{x} is printed, followed by a
three-column matrix with columns \code{Df}, \verb{\%Dev} and \code{Lambda}.
The \code{Df} column is the number of nonzero coefficients (Df is a
reasonable name only for lasso fits). \verb{\%Dev} is the percent deviance
explained (relative to the null deviance).
}
\seealso{
\code{classo}, \code{predict} and \code{coef} methods.
}
\keyword{models}
\keyword{regression}
