% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_cyclomort.R
\name{guess_initial_parameters}
\alias{guess_initial_parameters}
\title{Produce initial parameter estimates based on mortality data}
\usage{
guess_initial_parameters(x, n, null_fits)
}
\arguments{
\item{x}{\code{cycloSurv} object representing time of death or censorship}

\item{n}{expected number of mortality seasons within a period}

\item{null_fits}{original estimate for mortality rate assuming constant 
hazard function}
}
\value{
a named vector of guesses for parameter values, used to initialize 
the fitting process
}
\description{
Uses a basic flexsurvreg exponential mortality model to find the average 
hazard value, and fits a mixed normal distribution model to estimate the 
peaks, season durations, and weight distributions for the model. These 
estimates are not meant to be fully accurate but instead are meant to be 
good initial guesses for the fit_cyclomort function.
}
