% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{d3_dep_jetpack}
\alias{d3_dep_jetpack}
\title{'d3.js' Dependency for Version 4 Jetpack}
\usage{
d3_dep_jetpack(offline = TRUE)
}
\arguments{
\item{offline}{\code{logical} to specify whether to use
a local copy of d3.js (\code{TRUE}) or use cdn (\code{FALSE})}
}
\value{
\code{htmltools::htmlDependency}
}
\description{
d3-jetpack is a set of nifty convenience wrappers that speed up
your daily work with d3.js. Must be included after \code{d3_dep_v4()}.
Learn more by reading \href{https://github.com/gka/d3-jetpack}{d3-jetpack}
or by watching this \href{https://www.youtube.com/watch?v=_5ky0AYq_Dg&t=4s}{YouTube}.
}
\examples{
\dontrun{

library(d3r)
library(htmltools)

tl <- tagList(tags$script(HTML(sprintf(
"
var x = 5;

var svg = d3.select('body')
    .append('svg');

svg.append('rect')
    .at({
        x: 100,
        y: 100,
        width: 100,
        height: 100
    })
    .st({
        fill: 'blue',
        stroke: 'purple'
    });
"
))), d3_dep_v4(), d3_dep_jetpack())
browsable(tl)



tl <- tagList(tags$script(HTML(sprintf(
 "
 var svg = d3.select('body')
     .append('svg');

 test_data = [{x: 250, y: 250}, {x: 300, y: 300}, {x: 300, y: 100}];

 svg.appendMany(test_data, 'circle')
     .at({
         cx: function(d){return d.x},
         cy: function(d){return d.y},
         r: 50
     })
     .st({
         fill: 'purple',
         stroke: 'blue'
     });
 "
))), d3_dep_v4(), d3_dep_jetpack())

browsable(tl)

}
}
\seealso{
Other 'd3' dependency functions: 
\code{\link{d3_dep_v3}()},
\code{\link{d3_dep_v4}()},
\code{\link{d3_dep_v5}()},
\code{\link{d3_dep_v6}()},
\code{\link{d3_dep_v7}()}
}
\concept{'d3' dependency functions}
