% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/toolsDaniel.R
\name{priorL2}
\alias{priorL2}
\title{L2 objective function for prior value}
\usage{
priorL2(p, mu, lambda = "lambda", fixed = NULL)
}
\arguments{
\item{p}{Namec numeric, the parameter value}

\item{mu}{Named numeric, the prior values}

\item{lambda}{Character of length one. The name of the penalty paramter in \code{p}.}

\item{fixed}{Named numeric with fixed parameter values (contribute to the prior value
but not to gradient and Hessian)}
}
\value{
List of class \code{obj}, i.e. objective value, gradient and Hessian as list.
}
\description{
As a prior function, it returns derivatives with respect to
the penalty parameter in addition to parameter derivatives.
}
\details{
Computes the constraint value
\deqn{\lambda \| p-\mu \|^2}{lambda*sum((p-mu)^2)}
and its derivatives with respect to p and lambda.
}
\examples{
p <- c(A = 1, B = 2, C = 3, lambda = 1)
mu <- c(A = 0, B = 0)
priorL2(p, mu, lambda = "lambda")
}
\seealso{
\link{wrss}, \link{constraintExp2}
}

