% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_stats_pred_obs}
\alias{calc_stats_pred_obs}
\title{Calculate Statistics for Model Prediction and/or Observed Data}
\usage{
calc_stats_pred_obs(type, b_coding, conds, ...)
}
\arguments{
\item{type}{character string, specifying the type of statistic to calculate.
Available options are \code{"cafs"}, \code{"quantiles"}, and \code{"delta_funs"}.}

\item{b_coding}{list for boundary coding (see \link{b_coding}).}

\item{conds}{character vector, specifying the conditions to include in
calculations (used for labeling and subsetting the model PDFs and the
observed data).}

\item{...}{Additional parameters passed on to the specific statistic
calculation function (see Details).}
}
\value{
A data frame with the calculated statistic across \code{conds}
(ordered according to \code{Source}).
}
\description{
This function derives statistics that can be calculated for both model
predictions and observed data. However, it does not calculate it, but
rather calls the respective backend functions.
Supported statistics currently include:
\itemize{
\item Conditional Accuracy Functions (CAFs; \code{\link[=calc_cafs]{calc_cafs()}})
\item Quantiles (\code{\link[=calc_quantiles]{calc_quantiles()}})
\item Delta Functions (\code{\link[=calc_delta_funs]{calc_delta_funs()}})
}
}
\details{
When calling this function the arguments \code{all_rts_u}/\code{all_rts_l} and/or
\code{all_pdfs} must be specified (see
\link{re_evaluate_model}, \link{obs_data}). Otherwise, the backend
functions won't work properly. Further arguments are:
\itemize{
\item for CAFS: \code{n_bins} controls the number of bins, with a default of 5.
\item for Quantiles and Delta Functions: \code{probs} c ontrols the quantiles to
calculate. Default is \code{seq(0.1, 0.9, 0.1)}
(see \code{\link[=drift_dm_default_probs]{drift_dm_default_probs()}}).
}

This function gets called by \link{calc_stats}
}
\keyword{internal}
