% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.drift_dm}
\alias{plot.drift_dm}
\title{Plot Components of a Drift Diffusion Model}
\usage{
\method{plot}{drift_dm}(
  x,
  ...,
  conds = NULL,
  col = NULL,
  xlim = NULL,
  legend = NULL,
  legend_pos = "topright",
  mfrow = NULL
)
}
\arguments{
\item{x}{an object of class \link{drift_dm}}

\item{...}{additional arguments passed forward.}

\item{conds}{character vector, specifying conditions to plot. Defaults to all
conditions in \code{x}.}

\item{col}{character vector, specifying colors for each condition. If a
single color is provided, it will be repeated for each condition.}

\item{xlim}{numeric vector of length 2, specifying the x-axis limits for
components related to the time space.}

\item{legend}{character vector, specifying legend labels corresponding to the
conditions.}

\item{legend_pos}{character, specifying the position of the legend on the
plot (e.g., \code{"topright"}).}

\item{mfrow}{an optional numeric vector of length 2, specifying the number of
rows and columns for arranging multiple panels in a single plot. If \code{NULL}
(default), \code{mfrow} will be \code{c(3,2)}.}
}
\value{
Nothing (\code{NULL}; invisibly)
}
\description{
This function generates plots for all components of a drift diffusion model
(DDM), such as drift rate, boundary, and starting condition. Each component
is plotted against the time or evidence space, allowing for visual inspection
of the model's behavior across different conditions.
}
\details{
The \code{plot.drift_dm} function provides an overview of key DDM components,
which include:
\itemize{
\item \code{mu_fun}: Drift rate over time.
\item \code{mu_int_fun}: Integrated drift rate over time.
\item \code{x_fun}: Starting condition as a density across evidence values.
\item \code{b_fun}: Boundary values over time.
\item \code{dt_b_fun}: Derivative of the boundary function over time.
\item \code{nt_fun}: Non-decision time as a density over time.
}

For each component, if multiple conditions are specified, they will be
plotted using different colors as specified in \code{color}.

When the evaluation of a model component fails, the respective component
will not be plotted, but no warning is thrown.
}
\examples{
# plot the component functions of the Ratcliff DDM
plot(ratcliff_dm())
plot(ratcliff_dm(var_non_dec = TRUE))
# Note: the variability in the drift rate for the Ratcliff DDM
# is not plotted! This is because it is not actually stored as a component
# function.

# plot the component functions of the DMC model
plot(dmc_dm(), col = c("green", "red"))

}
