% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_clustering.R
\name{select_r}
\alias{select_r}
\title{Cluster number selection}
\usage{
select_r(Y, r_range, asymm = F)
}
\arguments{
\item{Y}{array/matrix, order-3 Gaussian tensor/matrix observation}

\item{r_range}{matrix, candidates for the cluster number on each row; see "details"}

\item{asymm}{logic variable, if "TRUE", clustering assignment differs in different modes; if "FALSE", all the modes share the same clustering assignment}
}
\value{
a list containing the following:

\code{r} {vector, the cluster number among the candidates with minimal BIC value}

\code{bic} {vector, the BIC value for each candidiate}
}
\description{
Estimate the cluster number in the degree-corrected tensor block model based on BIC criterion. The choice of BIC
aims to balance between the goodness-of-fit for the data and the degree of freedom in the population model.
This function is restricted for the Gaussian observation.
}
\details{
\code{r_range} should be a two-column matrix for matrix and three-column matrix for tensor observation;

all the elements in \code{r_range} should be integer larger than 1;

symmetric case only allow candidates with the same cluster number on each mode;

observations with non-identical dimension on each mode are only applicable with \code{asymm = T}.
}
\examples{

test_data = sim_dTBM(seed = 1, imat = FALSE, asymm = FALSE, p = c(50,50,50), r = c(3,3,3),
                    core_control = "control", s_min = 0.05, s_max = 1,
                    dist = "normal", sigma = 0.5,
                    theta_dist = "pareto", alpha = 4, beta = 3/4)

r_range = rbind(c(2,2,2), c(3,3,3),c(4,4,4),c(5,5,5))
selection <- select_r(test_data$Y, r_range, asymm = FALSE)
}
