% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dabr.R
\name{select_all}
\alias{select_all}
\alias{select_all.MariaDBConnection}
\title{Select all the records}
\usage{
select_all(conn, ...)

\method{select_all}{MariaDBConnection}(conn, table, quiet = FALSE, ...)
}
\arguments{
\item{conn}{\code{MariaDBConnection} connection object.}

\item{...}{Optional parameters.}

\item{table}{Name of the table.}

\item{quiet}{Boolean flag to hide status messages.}
}
\value{
Data frame with records.
}
\description{
Select all the records inside a particular table, use the \code{table}
parameter.
}
\examples{
\dontrun{
conn <- open_conn_mysql("sys", "root")
out <- select_all(conn, "sys_config")
close_conn(conn)
}
}
\seealso{
Other DB functions: 
\code{\link{close_conn}()},
\code{\link{insert}()},
\code{\link{list_tables}()},
\code{\link{open_conn_mysql}()},
\code{\link{select}()},
\code{\link{update}()}
}
\concept{DB functions}
