% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fingerprintCEE.R
\name{fingerprintCEE}
\alias{fingerprintCEE}
\title{Optimal Fingerprinting with Estimating Equations.}
\usage{
fingerprintCEE(
  Xtilde,
  Y,
  mruns,
  ctlruns.1,
  ctlruns.2,
  nS,
  nT,
  nB = 0,
  conf.level = 0.9,
  cal.a = TRUE,
  missing = FALSE,
  ridge = 0
)
}
\arguments{
\item{Xtilde}{\eqn{n \times p} matrix, signal pattern to be detected.}

\item{Y}{\eqn{n \times 1} matrix, length \eqn{nS \times nT}, observed data.}

\item{mruns}{number of ensembles to estimate the corresponding pattern. 
It is used as the scale of the covariance matrix for Xi.}

\item{ctlruns.1}{\eqn{m \times n} matrix, a group of \eqn{m} independent control 
runs for estimating covariance matrix, which is used in point estimation of 
the signal factors.}

\item{ctlruns.2}{\eqn{m \times n} matrix, another group of \eqn{m} independent control 
runs for estimating the corresponding confidence interval of the signal factors, 
default same as ctlruns.1.}

\item{nS}{number of locations for the observed responses.}

\item{nT}{number of time steps for the observed responses.}

\item{nB}{number of replicates in bootstrap.}

\item{conf.level}{confidence level for confidence interval estimation.}

\item{cal.a}{indicator for calculating the a value, otherwise use default value a = 1.}

\item{missing}{indicator for whether missing values present in Y.}

\item{ridge}{shrinkage value for adjusting the method for missing observations if missing = TRUE.}
}
\value{
a list of the fitted model including point estimate and
interval estimate of beta and a coefficients and corresponding estimate of 
variance, together with the residuals for model diagnostics.
}
\description{
This function estimates the signal factors and corresponding confidence 
interval via the estimating equation methods.
}
\examples{
## load the example dataset
data(simDat)
Cov <- simDat$Cov[[1]]
ANT <- simDat$X[, 1]
NAT <- simDat$X[, 2]

## generate the simulated data set
## generate regression observation
Y <- MASS::mvrnorm(n = 1, mu = ANT + NAT, Sigma = Cov)
## generate the forcing responses
mruns <- c(1, 1)
Xtilde <- cbind(MASS::mvrnorm(n = 1, mu = ANT, Sigma = Cov / mruns[1]),
                MASS::mvrnorm(n = 1, mu = NAT, Sigma = Cov / mruns[2]))
## control runs
ctlruns <- MASS::mvrnorm(100, mu = rep(0, nrow(Cov)), Sigma = Cov)
## ctlruns1 for the point estimation and ctlruns2 for the interval estimation
ctlrun.1 <- ctlrun.2 <- ctlruns
## number of locations
nS <- 25
## number of year steps
nT <- 10
## call the function to estimate the signal factors via CEE
fingerprintCEE(Xtilde, Y, mruns, 
               ctlrun.1, ctlrun.2,
               nS, nT, nB = 10,
               conf.level = 0.9, 
               cal.a = TRUE,
               missing = FALSE, ridge = 0)
}
\references{
\itemize{ 
\item Sai etal, Optimal Fingerprinting with Estimating Equations, 2023, 
      Journal of Climate.}
}
\author{
Yan Li
}
