% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_kmeans.R
\name{cluster_kmeans}
\alias{cluster_kmeans}
\title{k-means}
\usage{
cluster_kmeans(k = 1)
}
\arguments{
\item{k}{The number of clusters to form.}
}
\value{
A k-means object.
}
\description{
Creates a clusterer object that
uses the k-means method
It wraps the stats library.
}
\examples{
# setup clustering
model <- cluster_kmeans(k=3)

#load dataset
data(iris)

# build model
model <- fit(model, iris[,1:4])
clu <- cluster(model, iris[,1:4])
table(clu)

# evaluate model using external metric
eval <- evaluate(model, clu, iris$Species)
eval
}
