% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbmUnitFunctions.R
\name{linearUnitRbm}
\alias{linearUnitRbm}
\title{Calculates the linear neuron output no transfer function}
\usage{
linearUnitRbm(rbm, data, biases, weights, runParams,
  matMult = getParameter(".matMult", ...), ...)
}
\arguments{
\item{rbm}{A instance of the class \code{\linkS4class{RBM}}.}

\item{data}{A matrix with the data for the calculations.}

\item{biases}{The biases for the calculations.}

\item{weights}{The weight matrix for the calculations.}

\item{runParams}{Parameters which indicates the status of the training.}

\item{matMult}{Matrix multiplication function.}

\item{...}{Additional parameters, used for paramete resolution.}
}
\value{
The real value and binary activations for the units
}
\description{
Calculates the linear neuron output with no transfer function from real
value input saved in \code{data}.
}
\details{
The return value is a list with the output of the neurons as first
entry and binary representation calculated through a comparison of the
output with random numbers. The random numbers a generated with the
function \code{\link{rnorm}}.
}
\seealso{
Other RBM unit functions: \code{\link{sigmoidUnitRbm}},
  \code{\link{tanhUnitRbm}}
}
\keyword{internal}

