% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2genepop.r
\name{gl2genepop}
\alias{gl2genepop}
\title{Converts a genlight object into genepop format (and file)}
\usage{
gl2genepop(
  x,
  outfile = "genepop.gen",
  outpath = NULL,
  pop.order = "alphabetic",
  output.format = "2_digits",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{outfile}{File name of the output file [default 'genepop.gen'].}

\item{outpath}{Path where to save the output file [default global working 
directory or if not specified, tempdir()].}

\item{pop.order}{Order of the output populations either "alphabetic" or a 
vector of population names in the order required by the user (see examples)
[default "alphabetic"].}

\item{output.format}{Whether to use a 2-digit format ("2_digits") or 3-digits
format ("3_digits") [default "2_digits"].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
Invisible data frame in genepop format
}
\description{
The genepop format is used by several external applications (for example
Neestimator2
(\url{http://www.molecularfisherieslaboratory.com.au/neestimator-software/}).
So the main idea is to create the genepop file and then run the other
software externally. As a feature, the genepop file is also returned as an
invisible data.frame by the function.
}
\examples{
\donttest{
require("dartR.data")
# SNP data
geno <- gl2genepop(possums.gl[1:3,1:9], outpath = tempdir())
head(geno)
test <- gl.filter.callrate(platypus.gl,threshold = 1)
popNames(test)
gl2genepop(test, pop.order = c("TENTERFIELD","SEVERN_ABOVE","SEVERN_BELOW"),
           output.format="3_digits", outpath = tempdir())
}

}
\seealso{
Other linker: 
\code{\link{gl2bayesAss}()},
\code{\link{gl2bayescan}()},
\code{\link{gl2bpp}()},
\code{\link{gl2demerelate}()},
\code{\link{gl2eigenstrat}()},
\code{\link{gl2fasta}()},
\code{\link{gl2faststructure}()},
\code{\link{gl2gds}()},
\code{\link{gl2genalex}()},
\code{\link{gl2geno}()},
\code{\link{gl2gi}()},
\code{\link{gl2hiphop}()},
\code{\link{gl2phylip}()},
\code{\link{gl2plink}()},
\code{\link{gl2related}()},
\code{\link{gl2sa}()},
\code{\link{gl2structure}()},
\code{\link{gl2treemix}()},
\code{\link{gl2vcf}()}
}
\author{
Custodian: Bernd Gruber (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{linker}
