% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sim.ind.r
\name{gl.sim.ind}
\alias{gl.sim.ind}
\title{Simulates individuals based on the allele frequencies provided via a genlight object.}
\usage{
gl.sim.ind(gl, n = 50, popname = NULL)
}
\arguments{
\item{gl}{-- name of the genlight object containing the SNP data}

\item{n}{-- number of individuals that should be simulated}

\item{popname}{-- a population name for the simulated individuals [default Null]}
}
\value{
a genlight object with n individuals.
}
\description{
This function simulates individuals based on the allele frequencies of a genlight object. The output is a genlight object with the same number of loci as the input genlight object.
}
\details{
The function can be used to simulate populations for sampling designs or for power analysis. Check the example below where the effect of drift is explored, by simply simulating several generation a genlight object and putting in the allele frequencies of the previous generation. The beauty of the function is, that it is lightning fast.
}
\examples{
glsim <- gl.sim.ind(testset.gl, n=10, popname="sims")
glsim
###Simulate drift over 10 generation 
# assuming a bottleneck of only 10 individuals
# [ignoring effect of mating and mutation]
# Simulate 20 individuals with no structure and 50 SNP loci
founder <- glSim(n.ind = 20, n.snp.nonstruc = 50, ploidy=2)
#number of fixed loci in the first generation

res <- sum(colMeans(as.matrix(founder), na.rm=TRUE) \%\%2 ==0)
simgl <- founder
#49 generations of only 10 individuals
for (i in 2:50) 
{
   simgl <- gl.sim.ind(simgl, n=10, popname="sims")
   res[i]<- sum(colMeans(as.matrix(simgl), na.rm=TRUE) \%\%2 ==0)
}
plot(1:50, res, type="b", xlab="generation", ylab="# fixed loci")


}
\author{
Bernd Gruber (bernd.gruber@canberra.edu.au)
}
