% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.recode.pop.r
\name{gl.recode.pop}
\alias{gl.recode.pop}
\title{Recode population assignments in a genelight object \{adegenet\}}
\usage{
gl.recode.pop(x, pop.recode, recalc = TRUE, mono.rm = TRUE, v = 1)
}
\arguments{
\item{x}{-- name of the genlight object containing SNP genotypes or a genind object containing presence/absence data [required]}

\item{pop.recode}{-- name of the csv file containing the population reassignments [required]}

\item{recalc}{-- Recalculate the locus metadata statistics if any individuals are deleted in the filtering [default TRUE]}

\item{mono.rm}{-- Remove monomorphic loci [default TRUE]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
A genlight object with the recoded and reduced data
}
\description{
This script recodes population assignments and/or deletes populations from a DaRT genlight SNP file 
based on information provided in a csv population recode file.
}
\details{
Individuals are assigned to populations based on the specimen metadata data file (csv) used with gl.read.dart(). 
Recoding can be used to amalgamate populations or to selectively delete or retain populations.

The population recode file contains a list of populations in the genelight object as
the first column of the csv file, and the new population assignments in the second column of the csv file.
The keyword Delete used as a new population assignment will result in the associated specimen being dropped from the dataset.

The script, having deleted populations, optionally identifies resultant monomorphic loci or loci
with all values missing and deletes them (using gl.filter.monomorphs.r). The script also optionally
recalculates the locus metadata as appropriate.
}
\examples{
\donttest{
   gl <- gl.recode.pop(gl, pop.recode="pop_recode_table_0.csv")
}
}
\seealso{
\code{\link{gl.filter.monomorphs}}
}
\author{
Arthur Georges (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
