% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.rdepth.r
\name{gl.filter.rdepth}
\alias{gl.filter.rdepth}
\title{Filters loci based on counts of sequence tags scored at a locus (read
 depth)}
\usage{
gl.filter.rdepth(
  x,
  lower = 5,
  upper = 50,
  plot.out = TRUE,
  plot_theme = theme_dartR(),
  plot_colors = two_colors,
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or tag
presence/absence data [required].}

\item{lower}{Lower threshold value below which loci will be removed
[default 5].}

\item{upper}{Upper threshold value above which loci will be removed
[default 50].}

\item{plot.out}{Specify if plot is to be produced [default TRUE].}

\item{plot_theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot_colors}{List of two color names for the borders and fill of the
plots [default two_colors].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default 2, unless specified using gl.set.verbosity].}
}
\value{
Returns a genlight object retaining loci with a Read Depth in the
range specified by the lower and upper threshold.
}
\description{
SNP datasets generated by DArT report AvgCountRef and AvgCountSnp as counts
of sequence tags for the reference and alternate alleles respectively. These
can be used to back calculate Read Depth. Fragment presence/absence datasets
as provided by DArT (SilicoDArT) provide Average Read Depth and Standard
 Deviation of Read Depth as standard columns in their report.

Filtering on Read Depth using the companion script gl.filter.rdepth can be on
 the basis of loci with exceptionally low counts,
or loci with exceptionally high counts.
}
\details{
For examples of themes, see:
 \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
}
\examples{
 \donttest{
# SNP data
  gl.report.rdepth(testset.gl)
  result <- gl.filter.rdepth(testset.gl, lower=8, upper=50, verbose=3)
# Tag P/A data
  result <- gl.filter.rdepth(testset.gs, lower=8, upper=50, verbose=3)
  }
  res <- gl.filter.rdepth(platypus.gl)

}
\seealso{
\code{\link{gl.filter.rdepth}}

Other filter functions: 
\code{\link{gl.filter.allna}()},
\code{\link{gl.filter.callrate}()},
\code{\link{gl.filter.heterozygosity}()},
\code{\link{gl.filter.hwe}()},
\code{\link{gl.filter.ld}()},
\code{\link{gl.filter.locmetric}()},
\code{\link{gl.filter.maf}()},
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.overshoot}()},
\code{\link{gl.filter.parent.offspring}()},
\code{\link{gl.filter.pa}()},
\code{\link{gl.filter.reproducibility}()},
\code{\link{gl.filter.secondaries}()},
\code{\link{gl.filter.sexlinked}()},
\code{\link{gl.filter.taglength}()}
}
\author{
Custodian: Arthur Georges (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{filter functions}
