% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/node_methods_traversal.R
\name{Set}
\alias{Set}
\title{Traverse a Tree and Assign Values}
\usage{
Set(nodes, ...)
}
\arguments{
\item{nodes}{The \code{Node}s to traverse}

\item{...}{each argument can be a vector of values to be assigned. Recycled.}
}
\value{
invisibly returns the nodes (useful for chaining)
}
\description{
The method takes one or more vectors as an argument. It traverses the tree, whereby the values are picked
from the vector. Also available as OO-style method on \code{\link{Node}}.
}
\examples{
data(acme)
acme$Set(departmentId = 1:acme$totalCount, openingHours = NULL, traversal = "post-order")
acme$Set(head = c("Jack Brown",
                  "Mona Moneyhead",
                  "Dr. Frank N. Stein",
                  "Eric Nerdahl"
                  ),
         filterFun = function(x) !x$isLeaf
        )
print(acme, "departmentId", "head")
}
\seealso{
\code{\link{Node}}

\code{\link{Get}}
}

