% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicVisual.R
\name{basicVisual}
\alias{basicVisual}
\title{Produce distribution plots in the base R (graphics) style using \code{\link{plot}} and
\code{\link{barplot}}}
\usage{
basicVisual(v, vnam, doEval = TRUE)
}
\arguments{
\item{v}{The variable (vector) to be plotted.}

\item{vnam}{The name of the variable which will appear as the title of the plot.}

\item{doEval}{If TRUE, the plot itself is returned. Otherwise, the function returns
a character string containing standalone R code for producing the plot.}
}
\description{
Plot the distribution of a variable, depending on its data class, using the base R
plotting functions. Note that \code{basicVisual} is a \code{\link{visualFunction}}, compatible with the 
\code{\link{visualize}} and \code{\link{clean}} functions.
}
\details{
For character, factor, logical and labelled variables, a barplot is produced. For numeric, 
integer or Date variables, \code{basicVisual} produces a histogram instead. Note that for
integer and numeric variables, all non-finite (i.e. \code{NA}, \code{NaN}, \code{Inf}) values are
removed prior to plotting. For character, factor, labelled and logical variables, only \code{NA}
values are removed.
}
\examples{
 \dontrun{
 #Save a variable
   myVar <- c(1:10)
 #Plot a variable
   basicVisual(myVar, "MyVar")

 #Produce code for plotting a variable
   basicVisual(myVar, "MyVar", doEval = FALSE)
 }
}
\seealso{
\code{\link{visualize}}, \code{\link{standardVisual}}
}
