% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{check_csv_file}
\alias{check_csv_file}
\title{Check if the csv file has a correct format}
\usage{
check_csv_file(file, noconfirm = FALSE, filename = NULL,
  outfile = NULL)
}
\arguments{
\item{file}{The file's path}

\item{noconfirm}{A logical, this parameter indicates if the user must confirm
to change the name of the file and save in different file}

\item{filename}{A character, if this parameter is present then the name of
the file will be automatically set}

\item{outfile}{A character the path where the file will be save if it need to
be modify, NULL to use the file's directory}
}
\value{
A logical
}
\description{
Check if the csv file has a correct format
}
\examples{
library(dataesgobr)
file <- system.file("extdata", "fichero.csv", package="dataesgobr")
correct <- check_csv_file(file, noconfirm = TRUE)
correct <- check_csv_file(file, noconfirm = TRUE, outfile = tempdir())
correct <- check_csv_file(file, noconfirm = TRUE, filename = "nuevo.csv")
correct <- check_csv_file(file, noconfirm = TRUE, outfile = tempdir())
}
