% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-globalenv.R
\name{import-globalenv}
\alias{import-globalenv}
\alias{import_globalenv_ui}
\alias{import_globalenv_server}
\title{Import data from an Environment}
\usage{
import_globalenv_ui(
  id,
  globalenv = TRUE,
  packages = get_data_packages(),
  title = TRUE
)

import_globalenv_server(
  id,
  btn_show_data = TRUE,
  show_data_in = c("popup", "modal"),
  trigger_return = c("button", "change"),
  return_class = c("data.frame", "data.table", "tbl_df"),
  reset = reactive(NULL)
)
}
\arguments{
\item{id}{Module's ID.}

\item{globalenv}{Search for data in Global environment.}

\item{packages}{Name of packages in which to search data.}

\item{title}{Module's title, if \code{TRUE} use the default title,
use \code{NULL} for no title or a \code{shiny.tag} for a custom one.}

\item{btn_show_data}{Display or not a button to display data in a modal window if import is successful.}

\item{show_data_in}{Where to display data: in a \code{"popup"} or in a \code{"modal"} window.}

\item{trigger_return}{When to update selected data:
\code{"button"} (when user click on button) or
\code{"change"} (each time user select a dataset in the list).}

\item{return_class}{Class of returned data: \code{data.frame}, \code{data.table} or \code{tbl_df} (tibble).}

\item{reset}{A \code{reactive} function that when triggered resets the data.}
}
\value{
\itemize{
\item UI: HTML tags that can be included in shiny's UI
\item Server: a \code{list} with three slots:
\itemize{
\item \strong{status}: a \code{reactive} function returning the status: \code{NULL}, \code{error} or \code{success}.
\item \strong{name}: a \code{reactive} function returning the name of the imported data as \code{character}.
\item \strong{data}: a \code{reactive} function returning the imported \code{data.frame}.
}
}
}
\description{
Let the user select a dataset from its own environment or from a package's environment.
}
\examples{
if (interactive()) {
  library(shiny)
  library(datamods)

  # Create some data.frames

  my_df <- data.frame(
    variable1 = sample(letters, 20, TRUE),
    variable2 = sample(1:100, 20, TRUE)
  )

  results_analysis <- data.frame(
    id = sample(letters, 20, TRUE),
    measure = sample(1:100, 20, TRUE),
    response = sample(1:100, 20, TRUE)
  )


  # Application

  ui <- fluidPage(
    fluidRow(
      column(
        width = 4,
        import_globalenv_ui("myid")
      ),
      column(
        width = 8,
        tags$b("Import status:"),
        verbatimTextOutput(outputId = "status"),
        tags$b("Name:"),
        verbatimTextOutput(outputId = "name"),
        tags$b("Data:"),
        verbatimTextOutput(outputId = "data")
      )
    )
  )

  server <- function(input, output, session) {

    imported <- import_globalenv_server("myid")

    output$status <- renderPrint({
      imported$status()
    })
    output$name <- renderPrint({
      imported$name()
    })
    output$data <- renderPrint({
      imported$data()
    })

  }

  shinyApp(ui, server)
}
}
