% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{treevol}
\alias{treevol}
\title{Diameter, height and volume for Black Cherry Trees}
\format{
A data frame with 31 observations and three variables
\describe{
\item{dbh}{diameter at breast height, in cm}
\item{htot}{total height, in m}
\item{volume}{volume of timber, in cubic meters}
 }
}
\source{
Ryan, T. A., Joiner, B. L. and Ryan, B. F. (1976) The Minitab Student Handbook. Duxbury Press.
}
\usage{
data(treevol)
}
\description{
This data set provides measurements of the diameter, height and volume of timber in 31 felled black cherry trees.
This dataframe is a slight modification to the original dataframe "trees" from the datasets R package.
}
\examples{
pairs(treevol, panel = panel.smooth, main = "treevol dataframe")
plot(volume ~ dbh, data = treevol, log = "xy")
coplot(log(volume) ~ log(dbh) | htot, data = treevol,
       panel = panel.smooth)
summary(m1 <- lm(log(volume) ~ log(dbh), data = treevol))
summary(m2 <- update(m1, ~ . + log(htot), data = treevol))
anova(m1,m2)
}
\keyword{datasets}
