% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalt.r
\name{pvalt}
\alias{pvalt}
\title{Obtain the P-value for a Standard t-distributed random variable}
\usage{
pvalt(t.value, df, decnum = 14)
}
\arguments{
\item{t.value}{A numeric random variable following a t-student pdf
distribution.}

\item{df}{degrees of freedom of the random variable following a
t-student pdf distribution.}

\item{decnum}{the number of decimals to be used in the output.
The default is set to 5.}
}
\value{
The function returns the P-value or probability of getting a
value as large as t.value.
}
\description{
Function to compute the P-value for a Standard t-distributed random variable.
}
\details{
It is suited to compute the P-value for any random variable following a
Standard  t probability density function. For instance, to obtain
the p-value in a t-test.
}
\examples{
## Load dataset
 df <- datana::fertiliza2
 head(df)
 ## Computes the t-test statistics (from the 'stats' package)
t.value <- stats::t.test(df$vol)
t.value
 t.v <- as.numeric(t.value$statistic);t.v
 deg.f <- as.numeric(t.value$parameter);deg.f

 ## Obtaining the p ##  pvalt(t.v,deg.f)

}
\author{
Christian Salas-Eljatib
}
