% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{encodeUrlQuery}
\alias{encodeUrlQuery}
\alias{encodeUrlQuery,D1Client-method}
\title{Encode the Input for a URL Query Segment.}
\usage{
encodeUrlQuery(x, ...)

\S4method{encodeUrlQuery}{D1Client}(x, querySegment, ...)
}
\arguments{
\item{x}{A D1Client object.}

\item{...}{(Not yet used.)}

\item{querySegment}{: a string to encode}
}
\value{
the encoded form of the input
}
\description{
Encodes the characters of the input so they are not interpretted as reserved
characters in url strings.  Will also encode non-ASCII unicode characters.
}
\examples{
\dontrun{
d1c <- D1Client("STAGING", "urn:node:mnStageUCSB2")
fullyEncodedQuery <- paste0("q=id:",
    encodeUrlQuery(d1c, encodeSolr("doi:10.6085/AA/YBHX00_XXXITBDXMMR01_20040720.50.5")))
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}

