% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R, R/CNode.R, R/MNode.R
\docType{methods}
\name{getChecksum}
\alias{getChecksum}
\alias{getChecksum,CNode-method}
\alias{getChecksum,MNode-method}
\title{Get the checksum for the data object associated with the specified pid.}
\usage{
getChecksum(x, ...)

\S4method{getChecksum}{CNode}(x, pid, ...)

\S4method{getChecksum}{MNode}(x, pid, checksumAlgorithm = "SHA-1")
}
\arguments{
\item{x}{The CNode instance from which the checksum will be retrieved}

\item{...}{(Not yet used)}

\item{pid}{The identifier of the object}

\item{checksumAlgorithm}{The algorithm used to calculate the checksum. Default="SHA-1"}
}
\value{
character the checksum value, with the checksum algorithm as the attribute "algorithm"
}
\description{
A checksum is calculated for an object when it is uploaded to DataONE and
is submitted with the object's system metadata. The \code{'getChecksum'} method retrieves
the checksum from the specified coordinating node
}
\examples{
library(dataone)
cn <- CNode()
mn <- getMNode(cn, "urn:node:KNB")
pid <- "doi:10.5063/F1QN64NZ"
chksum <- getChecksum(mn, pid)
pid <- "doi:10.5063/F1QN64NZ"
cn <- CNode()
pid <- "doi:10.5063/F1QN64NZ"
chksum <- getChecksum(cn, pid)
}
\seealso{
\code{\link{D1Node-class}{D1Node}}{ class description.}
}

