/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryAncestorsTranslator
extends DIGQueryTranslator {
    protected boolean m_ancestors;

    public DIGQueryAncestorsTranslator(String predicate, boolean ancestors) {
        this(ancestors ? null : "*", predicate, ancestors ? "*" : null, ancestors);
    }

    protected DIGQueryAncestorsTranslator(String subj, String pred, String obj, boolean anc) {
        super(subj, pred, obj);
        this.m_ancestors = anc;
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        if (this.m_ancestors) {
            Element ancestors = da.createQueryElement(query2, "ancestors");
            da.addClassDescription(ancestors, pattern.getSubject());
        } else {
            Element descendants = da.createQueryElement(query2, "descendants");
            da.addClassDescription(descendants, pattern.getObject());
        }
        return query2;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        return this.translateConceptSetResponse(response, query2, this.m_ancestors, da).andThen(new SingletonIterator(new Triple(this.m_ancestors ? query2.getSubject() : query2.getObject(), query2.getPredicate(), this.m_ancestors ? query2.getSubject() : query2.getObject())));
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        return null;
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        return !this.m_ancestors || da.isConcept(subject, premises);
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return this.m_ancestors || da.isConcept(object, premises);
    }
}

