% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataObject.R
\docType{methods}
\name{setPublicAccess}
\alias{setPublicAccess}
\alias{setPublicAccess,DataObject-method}
\title{Add a Rule to the AccessPolicy to make the object publicly readable.}
\usage{
setPublicAccess(x, ...)

\S4method{setPublicAccess}{DataObject}(x)
}
\arguments{
\item{x}{DataObject}

\item{...}{(not yet used)}
}
\value{
DataObject with modified access rules
}
\description{
To be called prior to creating the object in DataONE.  When called before 
creating the object, adds a rule to the access policy that makes this object
publicly readable.  If called after creation, it will only change the system
metadata locally, and will not have any effect on remotely uploaded copies of
the DataObject.
}
\examples{
data <- charToRaw("1,2,3\\n4,5,6\\n")
do <- new("DataObject", "id1", dataobj=data, "text/csv", 
  "uid=jones,DC=example,DC=com", "urn:node:KNB")
do <- setPublicAccess(do)
}
\seealso{
\code{\link{DataObject-class}}
}

