% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_count_expected_observations.R
\name{util_count_expected_observations}
\alias{util_count_expected_observations}
\title{Count Expected Observations}
\usage{
util_count_expected_observations(
  resp_vars,
  study_data,
  meta_data,
  label_col = LABEL,
  expected_observations = c("HIERARCHY", "ALL", "SEGMENT")
)
}
\arguments{
\item{resp_vars}{\link{character} the response variables, for that a value may be
expected}

\item{study_data}{\link{study_data}}

\item{meta_data}{\link{meta_data}}

\item{label_col}{\link{character} mapping attribute \code{colnames(study_data)} vs.
\code{meta_data[label_col]}}

\item{expected_observations}{\link{enum} HIERARCHY | ALL | SEGMENT. How should
\code{PART_VARS} be handled:
- \code{ALL}: Ignore, all observations are
expected
- \code{SEGMENT}: if \code{PART_VAR} is 1, an
observation is expected
- \code{HIERARCHY}: the default, if the
\code{PART_VAR} is 1 for this variable and
also for all \code{PART_VARS} of \code{PART_VARS}
up in the hierarchy, an observation is
expected.}
}
\value{
a vector with the number of expected observations for each
\code{resp_vars}.
}
\description{
Count participants, if an observation was expected, given the
\code{PART_VARS} from item-level metadata
}
\seealso{
Other missing_functions: 
\code{\link{util_all_intro_vars_for_rv}()},
\code{\link{util_filter_missing_list_table_for_rv}()},
\code{\link{util_get_code_list}()},
\code{\link{util_is_na_0_empty_or_false}()},
\code{\link{util_observation_expected}()},
\code{\link{util_remove_empty_rows}()},
\code{\link{util_replace_codes_by_NA}()}
}
\concept{missing_functions}
\concept{process}
\keyword{internal}
