% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Featurelists.R
\name{ListModelingFeaturelists}
\alias{ListModelingFeaturelists}
\title{Retrieve all modeling featurelists associated with a project}
\usage{
ListModelingFeaturelists(project)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}
}
\value{
An S3 object of class 'listOfFeaturelists', which is a
list of dataframes: each element of the list corresponds to one
featurelist associated with the project, and each dataframe has
one row and the following four columns:
\itemize{
  \item featurelistId. Unique alphanumeric identifier for the featurelist.
  \item projectId. Unique alphanumeric project identifier.
  \item features. Comma-separated character string listing the variables included in the
    featurelist.
  \item name. Character string giving the name of the featurelist.
}
}
\description{
In time series projects, a new set of modeling features is created after setting the
partitioning options. These features are automatically derived from those in the project's
dataset and are the features used for modeling. Modeling features are only accessible once
the target and partitioning options have been set. In projects that don't use time series
modeling, once the target has been set, ModelingFeaturelists and Featurelists will behave
the same.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  ListModelingFeaturelists(projectId)
}
}
