% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPredictions.R
\name{ListPredictions}
\alias{ListPredictions}
\title{Fetch all computed predictions for a project.}
\usage{
ListPredictions(project, modelId = NULL, datasetId = NULL)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{numeric. Optional. Filter returned predictions to only be predictions made
against the model specified by this model ID.}

\item{datasetId}{numeric. Optional. Filter returned predictions to only be predictions made
against the prediction dataset specified by this dataset ID.}
}
\value{
A data.frame specifying:
  \itemize{
    \item projectId character. The ID of the project the predictions were made in.
    \item datasetId character. The dataset ID of the dataset used to make predicitons.
    \item modelId character. The model ID of the model used to make predictions.
    \item predictionId character. The unique ID corresponding to those predictions. Use
      \code{GetPredictions(projectId, predictionId)} to fetch the individual predictions.
  }
}
\description{
This function itemizes the predictions available for a given project, model, and/or dataset.
Note that this function does not actually return the predictions. Use
\code{GetPredictions(projectId, predictionId)} to get the predictions for a particular
set of predictions.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  predictions <- ListPredictions(projectId)
}
}
