% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComplianceDocumentation.R
\name{DownloadComplianceDocTemplate}
\alias{DownloadComplianceDocTemplate}
\title{Download a compliance doc template (in JSON format).}
\usage{
DownloadComplianceDocTemplate(filename = "template.json",
  templateId = NULL, type = NULL)
}
\arguments{
\item{filename}{character. Filename of file to save the compliance doc template to.}

\item{templateId}{character. Optional. The ID of the template to use in generating custom
model documentation.}

\item{type}{character. Optional. The type of compliance doc to get. Can be "normal" to retrieve
the default template or "timeSeries" to get the default time series template.}
}
\value{
Nothing returned, but downloads the file to the stated filename.
}
\description{
Download a compliance doc template (in JSON format).
}
\examples{
\dontrun{
  DownloadComplianceDocTemplate("template.json")  # download the default template
  # download the default template
  DownloadComplianceDocTemplate("template.json", type = "normal")
  # download the default time series template
  DownloadComplianceDocTemplate("template.json" type = "timeSeries")
  templateId <- "5cf85080d9436e5c310c796d"
  DownloadComplianceDocTemplate(templateId) # Download a custom template for a specific ID.
}
}
